<?php
/**
 * jobber job board platform
 *
 * @author     Filip C.T.E. <http://www.filipcte.ro> <me@filipcte.ro>
 * @license    You are free to edit and use this work, but it would be nice if you always referenced the original author ;)
 *             (see license.txt).
 * 
 * Postman class is a generic class that handles all e-mail operations
 */

class Postman
{
	function __construct()
	{ }

	// Send a job post to a friend
	public function MailSendToFriend($friend_email, $my_email)
	{
		$msg = "Te recomiendo que visites el siguiente casting: ";
		$msg .= "\n\n".$_SERVER['HTTP_REFERER'];
		$msg .= "\n\n---\nEmail enviado desde: " . $my_email;
		
		$subject = 'Te recomiendo este casting';

		if ($friend_email != '' && $my_email != '' && validate_email($friend_email) && validate_email($my_email))
		{
			$mailer = $this->getConfiguredMailer();
			
			$mailer->SetFrom($my_email);
    		$mailer->AddAddress($friend_email);
			$mailer->Subject = $subject;
			$mailer->Body = $this->nl2br($msg);
			$mailer->AltBody = $msg;
			
			if ($mailer->Send())
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}
	
	// Send email to company when applying online
	public function MailApplyOnline($data)
	{
		$mailer = $this->getConfiguredMailer();
		
		$msg = $data['apply_msg'];
		$msg .= "\n\n---\nEmail enviado desde: " . $_SERVER['HTTP_REFERER'];

		$subject = "Interesado en el casting '" . $data['job_title'] ."' - ".SITE_NAME;

    	$mailer->SetFrom($data['apply_email'], $data['apply_name']);
    	$mailer->AddAddress($data['company_email'], $data['company_name']);
    	$mailer->Subject = $subject;
    	$mailer->Body = $this->nl2br($msg);
    	$mailer->AltBody = $msg;
    	
		if ($data['attachment_filename'] != '')
		{
    		$mailer->AddAttachment($data['attachment_path'], $data['attachment_filename']);
		}

		if ($mailer->Send())
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	// Send mail to admin when a job is posted
	public function MailPublishToAdmin($data)
	{

		/*Datos de conexion a la base de datos*/
		$db_host = "localhost";
		$db_user = "urh8gvntwvah6";
		$db_pass = "1&j@1*5_4}r5";
		$db_name = "dby4f87j9q4g2f";

		$con = mysqli_connect($db_host, $db_user, $db_pass, $db_name);
		if(mysqli_connect_errno()){
			echo 'No se pudo conectar a la base de datos : '.mysqli_connect_error();
		}
	
		$email_validar = $data['poster_email'];
		$spammer_email = mysqli_query($con, "SELECT * FROM spam WHERE email = '$email_validar'");
		$num_filas_email = mysqli_num_rows($spammer_email);

		$ip_validar = $_SERVER['REMOTE_ADDR'];
		$spammer_ip = mysqli_query($con, "SELECT * FROM spam WHERE ip = '$ip_validar'");
		$num_filas_ip = mysqli_num_rows($spammer_ip);



		$msg = '';
		$job_title = BASE_URL . URL_JOB .'/' . $data['id'] . '/' . $data['url_title'] . '/';
		
		if ($data['check_poster_email'] == 0)
		{
			$msg .= "\nActivar casting: " . BASE_URL . "activate/" . $data['id'] . "/" . $data['auth'] . "/";
		$msg .= "\n\nEliminar y marcar como SPAM: " . BASE_URL . "admin/spam.php?id=" . $data['id'] . "&ip=" . $_SERVER['REMOTE_ADDR'] . "&email=" . $data['poster_email'];
		}
		
		$msg .= "\n\n---\nTitulo: " . $data['title'];
		$msg .= "\nPublicado por: " . $data['company'];
		$msg .= "\n\n" . $data['description'];
		$msg .= "\n\nURL: " . $data['url'];
		$msg .= "\n\n---\nPublicado por: " . $data['poster_email'];
		$msg .= "\nEnlace: " . $job_title;
		$msg .= "\n---\nActivar casting: " . BASE_URL . "activate/" . $data['id'] . "/" . $data['auth'] . "/";
		$msg .= "\nEditar casting: " . BASE_URL . "post/" . $data['id'] . "/" . $data['auth'] . "/";
		$msg .= "\nDesactivar casting: " . BASE_URL . "deactivate/" . $data['id'] . "/" . $data['auth'] . "/";
		$msg .= "\n\n---\nIP: " . $_SERVER['REMOTE_ADDR'];
		$msg .= "\nFecha de solicitud: " . $data['created_on'];

		$subject = "Casting: " . $data['title'];
		
		$mailer = $this->getConfiguredMailer();
			
		$mailer->SetFrom(NOTIFY_EMAIL, SITE_NAME);
    	$mailer->AddAddress(NOTIFY_EMAIL);
		$mailer->Subject = $subject;
		$mailer->Body = $this->nl2br($msg);
		$mailer->AltBody = $msg;

		if ($num_filas_email == 0 && $num_filas_ip == 0){
			$mailer->Send();
		}


	}
	
	// Send mail to user when posting first time (thus the post needs to be moderated)
	public function MailPublishPendingToUser($poster_email)
	{
		$msg = "Hola!";
		$msg .= "\n\nTu solicitud de publicación de casting nos acaba de llegar ahora mismo. Vamos a proceder a validarlo manualmente por lo que puede que pase un ratito hasta que lo publiquemos en la web. ";
		$msg .= "\n\nNo te preocupes, te avisaremos por email en cuanto esté publicado. No tardamos mas de 24 horas, aunque a veces es cuestión de minutos ;)";
		$msg .= "\n\nMucha suerte con el casting!";
		$msg .= "\n\nNota: Si pasadas 48 horas no te hemos confirmado la publicación del casting revisa las condiciones de publicación de castings.";
		
		$subject = "Casting pendiente de aprobación - " . SITE_NAME;
		
		if ($poster_email != '' && validate_email($poster_email))
		{
			$mailer = $this->getConfiguredMailer();
			
			$mailer->SetFrom(NOTIFY_EMAIL, SITE_NAME);
	    	$mailer->AddAddress($poster_email);
			$mailer->Subject = $subject;
			$mailer->Body = $this->nl2br($msg);
			$mailer->AltBody = $msg;
			
			$mailer->Send();
		}
	}
	
	// Send mail to user when a post is published
	public function MailPublishToUser($data, $url=BASE_URL)
	{
		$msg = "Hola!\n\n";
		$msg .= "Enhorabuena! Tu casting ha sido publicado y está disponible en: " . $url . URL_JOB ."/" . $data['id'] . "/" . $data['url_title'] . "/";
		$msg .= "\n\nA partir de este momento será publicado también automaticamente en nuestras redes sociales para darlo a conocer al mayor número de personas. Recuerda que puedes editarlo cuando quieras o desactivarlo utilizando los enlaces que te dejamos a continuación:";
		$msg .= "\n\n---\nPara editarlo: " . $url . "post/" . $data['id'] . "/" . $data['auth'] . "/";
		$msg .= "\nPara desactivarlo: " . $url . "deactivate/" . $data['id'] . "/" . $data['auth'] . "/";
		$msg .= "\n\n---\n\nMucha suerte con el casting";
		
		$subject = 'Tu casting ha sido publicado - ' . SITE_NAME;
		
		if ($data['poster_email'] != '' && validate_email($data['poster_email']))
		{
			$mailer = $this->getConfiguredMailer();
			
			$mailer->SetFrom(NOTIFY_EMAIL, SITE_NAME);
	    	$mailer->AddAddress($data['poster_email']);
			$mailer->Subject = $subject;
			$mailer->Body = $this->nl2br($msg);
			$mailer->AltBody = $msg;
			
			$mailer->Send();
		}
	}
	
	// Send mail to user when a post is activated (after first-time post)
 	public function MailPostActivatedToUser($data, $url=BASE_URL)
    {
        $this->MailPublishToUser($data, $url);
    }
	
	// Send mail to admin when someone posts a new spam word
	public function MailReportSpam($data)
	{
		$job_title = BASE_URL . URL_JOB .'/' . $data['id'] . '/' . $data['url_title'] . '/';
		
		$msg = '';
		
		$msg .= "Following ad was reported as false/spam:\n--\n\n";
		$msg .= $job_title;
		$msg .= "\n\n" . $data['title'] . " at " . $data['company'];
		$msg .= "\n\n" . $data['description'];
		$msg .= "\n\n--- \n Published by: " . $data['poster_email'];
		$msg .= "\n---\nEdit: " . BASE_URL . "post/" . $data['id'] . "/" . $data['auth'] . "/";
		$msg .= "\nDeactivate: " . BASE_URL . "deactivate/" . $data['id'] . "/" . $data['auth'] . "/";
		$msg .= "\n---\nIP: " . $_SERVER['REMOTE_ADDR'];
		$msg .= "\nDate: " . $data['created_on'];
		
		$subject = '[SPAM on ' . SITE_NAME . '] ' . $job_title;
		
		$mailer = $this->getConfiguredMailer();
			
		$mailer->SetFrom(NOTIFY_EMAIL, SITE_NAME);
    	$mailer->AddAddress(NOTIFY_EMAIL);
		$mailer->Subject = $subject;
		$mailer->Body = $this->nl2br($msg);
		$mailer->AltBody = $msg;
		
		$mailer->Send();
	}
	
	public function MailContact($name, $email, $msg)
	{
		$msg .= "\n\n---\nIP: " . $_SERVER['REMOTE_ADDR'];
		$msg .= "\nDate: " . date('Y-m-d H:i');

		$subject = "[" . SITE_NAME . "] contact";
		
		$mailer = $this->getConfiguredMailer();
			
		$mailer->SetFrom($email, $name);
    	$mailer->AddAddress(NOTIFY_EMAIL);
		$mailer->Subject = $subject;
		$mailer->Body = $this->nl2br($msg);
		$mailer->AltBody = $msg;
		
		if($mailer->Send())
		{
			return true;
		}
		else
		{
			return false;
		}	
	}

	private function getConfiguredMailer()
	{
		global $settings;
		
		$mailer = new PHPMailer();
		$mailer->Mailer = $settings['mailer_mailer'];
		$mailer->CharSet = $settings['mailer_encoding'];
		
		if($settings['mailer_mailer'] == 'smtp')
		{
			$mailer->Host = $settings['mailer_smtp_host'];
			$mailer->Port = $settings['mailer_smtp_port'];

			if ($settings['mailer_smtp_requires_authentication'])
			{
				$mailer->SMTPAuth = true;
				$mailer->SMTPSecure = $settings['mailer_smtp_secure_connection_prefix'];
				
				$mailer->Username = $settings['mailer_smtp_username'];
				$mailer->Password = $settings['mailer_smtp_password'];
			}
		}
		
		return $mailer;
	}
	
	private function nl2br($text)
	{
		return str_replace(array("\r\n", "\r", "\n"), "<br />", $text);
	}
}
?>